

#include <Wire.h>


/*****************************************************************
 **     Define Register Address (IOCON.BANK=0 [Default])        **
 *****************************************************************/

 #define IODIRA     0x00     //Set Direction PA : 1= Input ,0=Output
 #define IODIRB     0x01     //Set Direction PB

 #define IOCON      0x0A     //Set Config Reg.

 #define GPPUA      0x0C     //Set Pullup Input PA  : 1=Enable PullUp ,0=Disable PullUp
 #define GPPUB      0x0D     //Set Pullup Input PB

 #define GPIOA      0x12     //IN/OUT DATA PORTA
 #define GPIOB      0x13     //IN/OUT DATA PORTB
 
 #define GPINTENA   0x04     //Reg. Select PIN Enable Interrupt-On-Chang For GPA
 #define GPINTENB   0x05     //Reg. Select PIN Enable Interrupt-On-Chang For GPB
  
 #define DEFVALA    0x06     //Reg. Select Value-bit Compare for Interrupt-On-Chang  In GPA  
 #define DEFVALB    0x07     //Reg. Select Value-bit Compare for Interrupt-On-Chang  In GPB  
 
 #define INTCONA    0x08     //Reg. Select Compare PIN GPA current with vale Reg.DEFVALA or Previous Value PIN GPA   
 #define INTCONB    0x09     //Reg. Select Compare PIN GPB current with vale Reg.DEFVALA or Previous Value PIN GPB




 /***************************************************************
  **       Define Control Byte Address for MCP23017            **
  **     When A0,A1,A2 = 0     (0100 A2A1A0 X)                 **
  ***************************************************************/
   
 #define  CTRL_Byte   0x40  >> 1





/******************************************************************************* 
 **               Function I2C Write MCP23017 (Byte-Mode)  1 Sequence         **
 ** Parameter :                                                               **
 **            Control Byte Write MCP23017 = 0x40 (A2,A1,A0=0)                **   
 **            addr  = Register Address for write(1Byte)                      **
 **            dat   = Data to MCP23017                                       **    
 *******************************************************************************/
 
void I2C_WrMCP23017 (unsigned char addr,unsigned char dat)
{ 
  
  
//---------- Sent Slave address for Write ---------------

   Wire.beginTransmission(CTRL_Byte)         ;   //Send ID Code MCP32017  7-Bit  
 
//------------ Sent address Register --------------
 
   Wire.write(addr)                          ;	//Send Address Reg(0x00-0x15). to MCP23017

//------------- Sent data to MCP23017 ---------------

   Wire.write(dat)                           ;	//Send Data Control to MCP23017
  
   Wire.endTransmission();
 
 
}



/******************************************************************************
 **              Function I2C Read MCP32017 (Byte-Mode) 1 Sequence           **
 **                                                                          **
 ** Parameter :                                                              **
 **             Control Byte Read MCP23017 = 0x41 (A2,A1,A0=0)               **
 **             addr = Register Address for Read (1Byte)                     **
 ******************************************************************************/

 

unsigned char I2C_RdMCP23017(unsigned char addr)
 {
    unsigned char Rdx  ;

//------------- Sent Slave Address for Write------------	
  
   Wire.beginTransmission(CTRL_Byte)    ;    	//Send ID Code MCP23017 7-bit

//------------ Sent address Register --------------

   Wire.write(addr)                     ;     	//Send Address Reg. for Read MCP32017
  
   Wire.endTransmission()               ;


//-------------Sent Slave address for Read ------------

   Wire.requestFrom(CTRL_Byte,1)        ;      //Send ID Code 7 bit  ,Read 1 Byte

//------------- Read data 1 Byte ------------
   
   Rdx = Wire.read()                    ;					
  
   return Rdx                           ;       //Return Data

  }




/*****************************************
 **     Function Initial MCP23017       **
 *****************************************/

 void init_MCP23017(void)
  {
   
    //---------------- Setup I/O Port --------------

    I2C_WrMCP23017(IOCON,0x28)     ;  //Config BANK0,Byte Mode,Enable MCP23017 AddressPin,INTB associated PGB

    I2C_WrMCP23017(IODIRA,0x00)    ;  //Set GPA = Output For LED
    I2C_WrMCP23017(IODIRB,0xFF)    ;  //Set GPB = Input For SW
   
    I2C_WrMCP23017(GPPUB,0xFF)     ;  //PullUp GPB Enable 


    //---------- Set Up Output Interrupt INTB ------------
 
   I2C_WrMCP23017(GPINTENB,0xFF)   ;  // Enable GPB[0..7] pin For Interrupt-On-Chang
    
   I2C_WrMCP23017(DEFVALB,0x0F)    ;  // Set Vale Compare to '1',Use 4 bit Low Compare with GPB[0..3] 
  
   I2C_WrMCP23017(INTCONB,0x0F)    ;  // Set Bit GPB[0..3] Compare with Value Reg.DEFVALB ,And GPB[4..7] Compare with previous GPB[4..7] PIN

  }

//******************************** SetUp ************************************
void setup() 
{ 
  Wire.begin()  ;
} 


/* ################################################################
   ##			                                         ##
   ##                        Main Program                        ##
   ##	                 				 	 ##
   ################################################################ */


void loop() 
{ 
    unsigned char sw = 0 ;

    init_MCP23017()  ;

       while(1)
	  {
	    
             sw = I2C_RdMCP23017(GPIOB)             ;   //Read Data from SW. GPB
         
             if(sw != 0xFF)                             //Check Press SW Bit=0
              {
	         I2C_WrMCP23017(GPIOA,sw)           ;   //On LED(Logic 0) bit at press sw.
		   
                 do                                     //Protect Press SW.Rebeat or Double
  	          {
                    sw = I2C_RdMCP23017(GPIOB)      ;   //Read Data from SW. GPB

	          }while(sw != 0xFF)                ;   //Check Release SW. 
	       } 
	     else  //Not Press SW. (0xFF)
	      {
                 I2C_WrMCP23017(GPIOA,0xFF)         ;   //Clear LED OFF  (LED Active Low)
	      }	  

          }
       delayMicroseconds(300);        
} 




